/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.tools.tinkeritem;

import com.marth7th.solidarytinker.register.SolidarytinkerSound;
import com.marth7th.solidarytinker.register.TinkerCuriosModifier;
import com.marth7th.solidarytinker.register.solidarytinkerModifiers;
import com.marth7th.solidarytinker.register.solidarytinkerToolstats;
import com.marth7th.solidarytinker.shelf.energy.FluxStorage;
import com.marth7th.solidarytinker.solidarytinker;
import com.marth7th.solidarytinker.util.compound.DynamicComponentUtil;
import com.marth7th.solidarytinker.util.method.ModifierLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ElectricBatons
extends ModifiableItem {
    private static ResourceLocation COOLING = solidarytinker.getResource("electric_baton_cooling");

    public ElectricBatons(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @NotNull
    public List<Component> getStatInformation(@NotNull IToolStackView tool, @Nullable Player player, @NotNull List<Component> tooltips, @NotNull TooltipKey key, @NotNull TooltipFlag tooltipFlag) {
        int[] color = new int[]{600829, 14937853};
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.addDurability();
        }
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            builder.add((IToolStat)ToolStats.ATTACK_DAMAGE);
            builder.add((IToolStat)ToolStats.ATTACK_SPEED);
        }
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("\u8fde\u9501\u95f4\u8ddd", ":" + String.format("%d", ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.DETECTION_RANGE)).intValue()) + "\u683c", color, 20, 20, false));
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("\u8fde\u9501\u6570\u91cf", ":" + String.format("%d", ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.TARGET_AMOUNT)).intValue()) + "\u4f4d", color, 20, 20, false));
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("\u5f53\u524d\u80fd\u91cf\u5b58\u50a8", ":" + this.getEnergyStorage(tool) + "/" + this.getMaxEnergyStorage(tool), color, 20, 20, false));
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltips, key, tooltipFlag);
        }
        return tooltips;
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Mob nextMob;
        Mob mob;
        Random random;
        block17: {
            block16: {
                random = new Random();
                if (!(target instanceof Mob)) break block16;
                mob = (Mob)target;
                if (playerIn instanceof ServerPlayer) break block17;
            }
            return InteractionResult.PASS;
        }
        ServerPlayer player = (ServerPlayer)playerIn;
        if (mob instanceof TamableAnimal) {
            return InteractionResult.PASS;
        }
        if (mob instanceof Villager) {
            return InteractionResult.PASS;
        }
        ServerLevel level = player.m_9236_();
        Mob currentTarget = mob;
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModDataNBT persistentData = tool.getPersistentData();
        float range = ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.DETECTION_RANGE)).floatValue();
        float amount = ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.TARGET_AMOUNT)).floatValue();
        int powerfulAttackLevel = ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)solidarytinkerModifiers.ENERGY_POWER_FUL_STATIC_MODIFIER.getId());
        boolean elsy = ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)solidarytinkerModifiers.HVE_STATIC_MODIFIER.getId()) > 0;
        boolean houGuoYu = ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)solidarytinkerModifiers.HOU_GUO_YU_STATIC_MODIFIER.getId()) > 0;
        int coolingDownTick = persistentData.getInt(COOLING);
        if (coolingDownTick > 0) {
            if (houGuoYu) {
                level.m_5594_(null, player.m_20097_(), SolidarytinkerSound.electric_cooldown.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            playerIn.m_5661_((Component)Component.m_237113_((String)("\u8fd8\u5728\u51b7\u5374,\u51b7\u5374\u65f6\u957f\u4e3a" + coolingDownTick + "\u79d2")).m_130938_(style -> style.m_178520_(15247101)), true);
            return InteractionResult.PASS;
        }
        int currentEnergy = this.getEnergyStorage((IToolStackView)tool);
        if (currentEnergy < 50000) {
            if (houGuoYu) {
                level.m_5594_(null, player.m_20097_(), SolidarytinkerSound.electric_not_full.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            playerIn.m_5661_((Component)Component.m_237113_((String)"\u7535\u91cf\u4e0d\u8db3\u4ee5\u53d1\u52a8\u4e00\u6b21\u57fa\u7840\u653b\u51fb").m_130938_(style -> style.m_178520_(12432125)), true);
            return InteractionResult.PASS;
        }
        mob.getPersistentData().m_128405_("electric_batons_extra_hurt", 3);
        int cooldownTick = this.calculateCooldown((IToolStackView)tool, (Player)player, random);
        if (cooldownTick > 0) {
            persistentData.putInt(COOLING, cooldownTick);
        }
        if (player.m_7500_()) {
            player.f_36096_.m_38946_();
        }
        this.costEnergy((IToolStackView)tool, 50000);
        ToolAttackUtil.attackEntity((IToolStackView)tool, (LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND, (Entity)mob, () -> 1.0, (boolean)false);
        int currentCost = Math.round((float)this.getMaxEnergyStorage((IToolStackView)tool) * 0.3f);
        if (elsy) {
            currentCost *= 2;
        }
        if (powerfulAttackLevel > 0) {
            this.runPowerfulAttack((LivingEntity)mob, (LivingEntity)player, powerfulAttackLevel, 1, currentCost, elsy);
            this.costEnergy((IToolStackView)tool, currentCost);
        }
        ArrayList<Mob> hasBeenAttackedMob = new ArrayList<Mob>();
        hasBeenAttackedMob.add(mob);
        level.m_5594_(null, player.m_20097_(), SolidarytinkerSound.electric_hit.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        int i = 0;
        while ((float)i < amount && (nextMob = this.getNearestMob(currentTarget, hasBeenAttackedMob, range)) != null) {
            if (!(nextMob instanceof TamableAnimal) && !(nextMob instanceof Villager)) {
                ToolAttackUtil.attackEntity((IToolStackView)tool, (LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND, (Entity)nextMob, () -> 1.0, (boolean)false);
                if (powerfulAttackLevel > 0) {
                    this.runPowerfulAttack((LivingEntity)nextMob, (LivingEntity)player, powerfulAttackLevel, i + 2, currentCost, elsy);
                }
                this.drawParticleBeam(currentTarget, nextMob, random, level);
                currentTarget = nextMob;
                hasBeenAttackedMob.add(nextMob);
            }
            ++i;
        }
        return InteractionResult.SUCCESS;
    }

    private int calculateCooldown(IToolStackView view, Player player, Random random) {
        int fastChargeLevel = view.getModifierLevel(solidarytinkerModifiers.FAST_CHARGE_STATIC_MODIFIER.getId());
        int rhyLevel = view.getModifierLevel(solidarytinkerModifiers.DEADLY_RHYTHM_STATIC_MODIFIER.getId());
        if (rhyLevel > 0 && random.nextInt(10) < 7) {
            return 0;
        }
        int baseCoolingDownTick = Math.max(8 - fastChargeLevel, 3);
        if (solidarytinker.TI && ModifierLevel.curioModifierLevel((LivingEntity)player, TinkerCuriosModifier.BHA_STATIC_MODIFIER.getId()) > 0) {
            if (baseCoolingDownTick < 4) {
                return 1;
            }
            return (int)((float)baseCoolingDownTick / 2.0f);
        }
        return baseCoolingDownTick;
    }

    private void drawParticleBeam(Mob mob1, Mob mob2, Random random, ServerLevel level) {
        double d0 = mob2.m_20185_() - mob1.m_20185_();
        double d1 = mob2.m_20186_() + (double)(mob2.m_20206_() * 0.5f) - (mob1.m_20186_() + (double)mob1.m_20192_() * 0.5);
        double d2 = mob2.m_20189_() - mob1.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = random.nextDouble();
        while (d4 < d3) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123815_, mob1.m_20185_() + d0 * (d4 += 0.3), mob1.m_20186_() + d1 * d4 + (double)mob1.m_20192_() * 0.5, mob1.m_20189_() + d2 * d4, 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private Mob getNearestMob(Mob mob1, List<Mob> beenAttackedMob, double range) {
        AABB aabb = new AABB(mob1.m_20097_()).m_82400_(range);
        List list = mob1.f_19853_.m_6443_(Mob.class, aabb, entity -> entity != mob1);
        Mob nearestMob = null;
        double currentRange = Double.MAX_VALUE;
        for (Mob mob : list) {
            if (beenAttackedMob.contains(mob) || !((double)mob.m_20270_((Entity)mob1) <= currentRange)) continue;
            currentRange = mob.m_20270_((Entity)mob1);
            nearestMob = mob;
        }
        return nearestMob;
    }

    private int getEnergyStorage(IToolStackView view) {
        return view.getPersistentData().getInt(FluxStorage.STORED_ENERGY);
    }

    private int getMaxEnergyStorage(IToolStackView view) {
        int add = view.getStats().getInt((IToolStat)solidarytinkerToolstats.ENERGY_CAPACITY);
        int base = view.getVolatileData().getInt(FluxStorage.MAX_ENERGY);
        return add + base;
    }

    private void costEnergy(IToolStackView view, int cost) {
        FluxStorage.removeEnergy(view, cost, false, true);
    }

    private void runPowerfulAttack(LivingEntity entity, LivingEntity attacker, int modifierLevel, int index, int cost, boolean hasElysia) {
        float scale = 1.2f * (1.0f - 0.06f * (float)(index - 1));
        if (hasElysia) {
            scale *= 2.0f;
        }
        float extraDamage = (float)cost * 0.01f * (float)modifierLevel;
        float totalDamage = extraDamage * scale;
        DamageSource powerAttack = new EntityDamageSource("power_attack", (Entity)attacker).m_19380_();
        entity.f_19802_ = 0;
        entity.m_6469_(powerAttack, totalDamage);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn.f_19797_ % 20 != 0) {
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModDataNBT persistentData = tool.getPersistentData();
        int coolingDownTick = persistentData.getInt(COOLING);
        if (coolingDownTick > 0) {
            persistentData.putInt(COOLING, coolingDownTick - 1);
        }
    }
}

